package com.ejie.ab04b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.dao.NumeracionExpedienteDao;
import com.ejie.ab04b.model.NumeracionExpediente;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Ab0475s00ServiceImpl generated by UDA, 27-jun-2017 11:01:08.
 * 
 * @author UDA
 */

@Service(value = "ab0475s00Service")
public class NumeracionExpedienteServiceImpl implements
		NumeracionExpedienteService {

	@Autowired
	private NumeracionExpedienteDao ab0475s00Dao;

	/**
	 * Inserts a single row in the Ab0475s00 table.
	 * 
	 *  ab0475s00
	 *            Ab0475s00
	 *  Ab0475s00
	 *
	 * @param ab0475s00 the ab 0475 s 00
	 * @return the numeracion expediente
	 */
	@Transactional(rollbackFor = Throwable.class)
	public NumeracionExpediente add(NumeracionExpediente ab0475s00) {
		return this.ab0475s00Dao.add(ab0475s00);
	}

	/**
	 * Updates a single row in the Ab0475s00 table.
	 * 
	 *  ab0475s00
	 *            Ab0475s00
	 *  Ab0475s00
	 *
	 * @param ab0475s00 the ab 0475 s 00
	 * @return the numeracion expediente
	 */
	@Transactional(rollbackFor = Throwable.class)
	public NumeracionExpediente update(NumeracionExpediente ab0475s00) {
		return this.ab0475s00Dao.update(ab0475s00);
	}

	/**
	 * Finds a single row in the Ab0475s00 table.
	 * 
	 *  ab0475s00
	 *            Ab0475s00
	 *  Ab0475s00
	 *
	 * @param ab0475s00 the ab 0475 s 00
	 * @return the numeracion expediente
	 */
	public NumeracionExpediente find(NumeracionExpediente ab0475s00) {
		return (NumeracionExpediente) this.ab0475s00Dao.find(ab0475s00);
	}

	/**
	 * Deletes a single row in the Ab0475s00 table.
	 * 
	 *  ab0475s00
	 *            Ab0475s00
	 *
	 * @param ab0475s00 the ab 0475 s 00
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(NumeracionExpediente ab0475s00) {
		this.ab0475s00Dao.remove(ab0475s00);
	}

	/**
	 * Finds a list of rows in the Ab0475s00 table.
	 * 
	 *  ab0475s00
	 *            Ab0475s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<Ab0475s00>
	 *
	 * @param ab0475s00 the ab 0475 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	public List<NumeracionExpediente> findAll(NumeracionExpediente ab0475s00,
			JQGridRequestDto jqGridRequestDto) {
		return (List<NumeracionExpediente>) this.ab0475s00Dao.findAll(
				ab0475s00, jqGridRequestDto);
	}

	/**
	 * Finds rows in the Ab0475s00 table using like.
	 * 
	 *  ab0475s00
	 *            Ab0475s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<Ab0475s00>
	 *
	 * @param ab0475s00 the ab 0475 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<NumeracionExpediente> findAllLike(
			NumeracionExpediente ab0475s00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		return (List<NumeracionExpediente>) this.ab0475s00Dao.findAllLike(
				ab0475s00, jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Filter method in the Ab0475s00 table.
	 * 
	 *  filterAb0475s00
	 *            Ab0475s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  JQGridResponseDto<Ab0475s00>
	 *
	 * @param filterAb0475s00 the filter ab 0475 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the JQ grid response dto
	 */
	public JQGridResponseDto<NumeracionExpediente> filter(
			NumeracionExpediente filterAb0475s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		List<NumeracionExpediente> listaAb0475s00 = this.ab0475s00Dao
				.findAllLike(filterAb0475s00, jqGridRequestDto, false);
		Long recordNum = this.ab0475s00Dao.findAllLikeCount(
				filterAb0475s00 != null ? filterAb0475s00
						: new NumeracionExpediente(), false);
		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<NumeracionExpediente>> reorderSelection = this.ab0475s00Dao
					.reorderSelection(filterAb0475s00, jqGridRequestDto,
							startsWith);
			return new JQGridResponseDto<NumeracionExpediente>(
					jqGridRequestDto, recordNum, listaAb0475s00,
					reorderSelection);
		}
		return new JQGridResponseDto<NumeracionExpediente>(jqGridRequestDto,
				recordNum, listaAb0475s00);
	}

	/**
	 * Searches rows in the Ab0475s00 table.
	 * 
	 *  filterAb0475s00
	 *            Ab0475s00
	 *  searchAb0475s00
	 *            Ab0475s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<TableRowDto<Ab0475s00>>
	 *
	 * @param filterAb0475s00 the filter ab 0475 s 00
	 * @param searchAb0475s00 the search ab 0475 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<TableRowDto<NumeracionExpediente>> search(
			NumeracionExpediente filterAb0475s00,
			NumeracionExpediente searchAb0475s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.ab0475s00Dao.search(filterAb0475s00, searchAb0475s00,
				jqGridRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in Ab0475s00 table.
	 * 
	 *  filterAb0475s00
	 *            Ab0475s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  Object
	 *
	 * @param filterAb0475s00 the filter ab 0475 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the object
	 */
	public Object reorderSelection(NumeracionExpediente filterAb0475s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.ab0475s00Dao.reorderSelection(filterAb0475s00,
				jqGridRequestDto, startsWith);
	}

}
